<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman filter tool layout.
 *
 * @version 4.1.1
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2022 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('JPATH_BASE') or die;

$data	= $displayData;
$layout	= $data['tab'];

// Load the form filters
$groupFilters = $data['view']->filterForm->getGroup('filter');

// Load the form list fields
$fieldset	= $data['view']->filterForm->getFieldset($layout);
$filters = array();

foreach ($fieldset as $fieldName => $field)
{
	if (strpos($fieldName,  'filter_') !== false)
	{
		$filters[$fieldName] = $field;
	}
}


?>
<?php if ($filters) : ?>
	<?php foreach ($filters as $fieldName => $field) : ?>
		<?php if (($fieldName != 'filter_search') && (stripos($fieldName, 'filter_') !== false)) : ?>
			<div class="js-stools-field-filter">
				<?php echo $field->input; ?>
			</div>
		<?php endif; ?>
	<?php endforeach; ?>
<?php endif; ?>

