<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman newsletter all view for frontend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Site
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import VIEW object class
jimport('joomla.application.component.view');

class BwPostmanViewNewsletters extends JViewLegacy
{
	protected $state		= null;
	protected $item			= null;
	protected $items		= null;
	protected $pagination	= null;
	
	/**
	 * Display
	 *
	 * @access	public
	 * @param	string Template
	 */
	public function display($tpl = null)
	{

		$app		= JFactory::getApplication();		 
		$uri      	= JFactory::getURI();
		$uri_string	= $uri->toString();
		$items 		= $this->get('Items');
		$state		= $this->get('State');
		$pagination = $this->get('Pagination');
		$params 	= $app->getPageParameters();
		$menu		= $app->getMenu()->getActive();
		$jinput		= JFactory::getApplication()->input;

		// Because the application sets a default page title, we need to get it
		// right from the menu item itself
		if (is_object($menu)) {
			$menu_params = new JRegistry();
			$menu_params->loadString($menu->params, 'JSON');
			if (!$menu_params->get('page_heading')) {
				$params->set('page_heading',	JText::_('COM_BWPOSTMAN_NLS'));
			}
		} 
		else {
			$params->set('page_heading',	JText::_('COM_BWPOSTMAN_NLS'));
		}

		// Get document object, set document title and add css
		$templateName	= $app->getTemplate();
//		$css_filename	= JPATH_BASE . '/templates/' . $templateName . '/css/com_bwpostman.css';
		$css_filename	= 'templates/' . $templateName . '/css/com_bwpostman.css';
		
		$document = JFactory::getDocument();
		$document->setTitle($params->get('page_title'));

		$document->addStyleSheet('components/com_bwpostman/assets/css/bwpostman.css');
		if (file_exists($css_filename)) $document->addStyleSheet($css_filename);
		
		// Save a reference into view
		$this->assignRef('items', $items);
		$this->assignRef('pagination', $pagination);
		$this->assignRef('params', $params);
		$this->assignRef('state', $state);
		$this->assign('uri', str_replace('&', '&amp;', $uri_string));

		// Set parent display
		parent::display($tpl);
		 
	}
}