<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman all newsletters queue template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

$user	= JFactory::getUser();
$userId	= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

?>

<div class="well well-small">
	<table class="adminlist table table-striped">
		<thead>
			<tr>
				<th width="30" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'NUM', 'a.id', $listDirn, $listOrder); ?></th>
				<th nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?></th>
				<th width="250" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_RECIPIENT', 'a.recipient', $listDirn, $listOrder); ?></th>
				<th nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_SUBJECT', 'a.subject', $listDirn, $listOrder); ?></th>
				<th width="30" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_TRIAL', 'a.trial', $listDirn, $listOrder); ?></th>
			</tr>
		</thead>
		<tbody>
		<?php 
		if (count($this->queue) > 0) : 
				foreach ($this->queue as $i => $item) : 
					?>
					<tr class="row<?php echo $i % 2; ?>">
						<td align="center"><?php echo $item->id; ?></td>
						<td><?php echo $this->escape($item->subject); ?></td>
						<td><?php echo $this->escape($item->description); ?></td>
						<td><?php echo $item->recipient; ?></td>
						<td><?php echo $item->trial; ?></td>
					</tr><?php
				endforeach;
			endif;
		?>
		</tbody>
	</table>
</div>
<input type="hidden" name="tab" value="queue" />
