<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman archive newsletters template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Load the tooltip behavior for the notes
JHTML::_('behavior.tooltip');

// Load the modal behavior for the newsletter preview
if (version_compare(JVERSION,'3.0.0','>=')) {
  JHTML::_('behavior.modal');
}
else {
	JHTML::_('behavior.modal');
	JHTML::_('behavior.modal', 'a.popup');
}

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

//Set context and layout state for filters
$this->context	= 'archive.newsletters';
$tab			= JFactory::getApplication()->setUserState($this->context . '.tab', 'newsletters');

/**
 * BwPostman Archived Newsletters Layout
 *
 * @package 	BwPostman-Admin
 * @subpackage 	Archive
 */
?>

<div id="bwp_view_lists">
	<form action="<?php echo $this->request_url; ?>" method="post" name="adminForm" id="adminForm" class="form-inline">
		<fieldset id="filter-bar" class="well well-small">
			<div class="filter-search fltlft pull-left">
				<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('SEARCH'); ?></label>
				<select name="filter_search_filter_nl" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->lists['filtersearch_nl'], 'value', 'text', $this->state->get('filter.search_filter_nl')) ; ?>
				</select>
				<input type="text" name="filter_search_nl" id="filter_search_nl" value="<?php echo $this->escape($this->state->get('filter.search_nl')); ?>" title="<?php echo JText::_('COM_BWPOSTMAN_FILTER_SEARCH_DESC'); ?>" />
				
				<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button type="button" class="btn" onclick="document.getElementById('filter_search_nl').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			</div>

			<div class="filter-select fltrt pull-right">
<?php /*
				<select name="filter_published" class="inputbox" onchange="this.form.submit()">
					<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
					<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.published'), true);?>
				</select>
				<select name="filter_access" class="inputbox" onchange="this.form.submit()">
					<option value=""><?php echo JText::_('JOPTION_SELECT_ACCESS');?></option>
					<?php echo JHtml::_('select.options', JHtml::_('access.assetgroups'), 'value', 'text', $this->state->get('filter.access'));?>
				</select>
*/?>
				<select name="filter_campaign" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->lists['campaign'], 'value', 'text', $this->state->get('filter.campaign')) ; ?>
				</select>

				<select name="filter_author" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->lists['author'], 'value', 'text', $this->state->get('filter.author')) ; ?>
				</select>
		        <?php
		        if (version_compare(JVERSION,'3.0.0','>=')) {
		          echo $this->pagination->getLimitBox();
				    }
		        ?>
			</div>
		</fieldset>
		
		<div class="row-fluid">
			<table class="adminlist table table-striped">
				<tbody>
					<tr>
						<td valign="top" width="90%">
							<ul class="bwp_tabs">
								<li class="open"><!-- We need to use the setAttribute-function because of the IE -->
									<button onclick="layout.setAttribute('value','newsletters');this.form.submit();" class="buttonAsLink_open"><?php echo JText::_('COM_BWPOSTMAN_ARC_NLS'); ?></button>
								</li>
								<li class="closed">
									<button onclick="layout.setAttribute('value','subscribers');this.form.submit();" class="buttonAsLink"><?php echo JText::_('COM_BWPOSTMAN_ARC_SUBS'); ?></button>
								</li>
								<li class="closed">
									<button onclick="layout.setAttribute('value','campaigns');this.form.submit();" class="buttonAsLink"><?php echo JText::_('COM_BWPOSTMAN_ARC_CAMS'); ?></button>
								</li>
								<li class="closed">
									<button onclick="layout.setAttribute('value','mailinglists');this.form.submit();" class="buttonAsLink"><?php echo JText::_('COM_BWPOSTMAN_ARC_MLS'); ?></button>
								</li>
							</ul>
				
							<div class="current">
								<table class="adminlist">
									<thead>
										<tr>
											<th width="30" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'NUM', 'a.id', $listDirn, $listOrder); ?></th>
											<th width="30" nowrap="nowrap">
												<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
											</th>
											<th><?php echo JHTML::_('grid.sort',  'Subject', 'a.subject', $listDirn, $listOrder); ?></th>
											<th nowrap="nowrap"><?php echo JHTML::_('grid.sort', 'COM_BWPOSTMAN_NL_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?></th>
											<th width="150" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_MAILING_DATE', 'mailing_date', $listDirn, $listOrder); ?></th>
											<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'Author', 'author', $listDirn, $listOrder); ?></th>
											<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_CAM_NAME' , 'campaign_id', $listDirn, $listOrder); ?></th>
											<th width="150"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_ARC_ARCHIVE_DATE', 'archive_date', $listDirn, $listOrder); ?></th>
										</tr>
									</thead>
									<tfoot>
										<tr>
											<td colspan="8"><?php echo $this->pagination->getListFooter(); ?></td>
										</tr>
									</tfoot>
									<tbody>
									<?php 
									if (count($this->items) > 0) {
										foreach ($this->items as $i => $item) : 
											$canCheckin	= $user->authorise('core.manage',		'com_bwpostman') || $item->checked_out == $userId || $item->checked_out == 0;
											$canEdit	= $user->authorise('core.edit',			'com_bwpostman.newsletter.'.$item->id);
											$canEditOwn	= $user->authorise('core.edit.own',		'com_bwpostman.newsletter.'.$item->id) && $item->created_by == $userId;
											$canChange	= $user->authorise('core.edit.state',	'com_bwpostman.newsletter.'.$item->id) && $canCheckin;
											?>
											<tr class="row<?php echo $i % 2; ?>">
												<td align="center"><?php echo $item->id; ?></td>
												<td align="center"><?php echo JHtml::_('grid.id', $i, $item->id); ?></td>
												<td><?php 
													echo $item->subject; 
													if ($item->mailing_date != '0000-00-00 00:00:00') { ?>&nbsp;&nbsp;
														<span class="cam_preview">  
															<span class="editlinktip hasTip" title="<?php echo JText::_('COM_BWPOSTMAN_ARC_SHOW_NL');?>::<?php echo $this->escape($item->subject); ?>">
																<a class="modal" href="<?php echo JRoute::_('index.php?option=com_bwpostman&view=newsletter&format=raw&layout=newsletter_html_modal&task=insideModal&nl_id='. $item->id);?>" rel="{handler: 'iframe', size: {x: 650, y: 450}}"><?php echo JText::_('COM_BWPOSTMAN_HTML_NL');?></a>&nbsp;
															</span>
															<span class="editlinktip hasTip" title="<?php echo JText::_('COM_BWPOSTMAN_ARC_SHOW_NL');?>::<?php echo $this->escape($item->subject); ?>">
																<a class="modal" href="<?php echo JRoute::_('index.php?option=com_bwpostman&view=newsletter&format=raw&layout=newsletter_text_modal&task=insideModal&nl_id='. $item->id);?>" rel="{handler: 'iframe', size: {x: 650, y: 450}}"><?php echo JText::_('COM_BWPOSTMAN_TEXT_NL');?></a>&nbsp;
															</span>
														</span>
													<?php } ?>
												</td>
												<td align="center"><?php echo $item->description; ?></td>
												<td align="center"><?php if ($item->mailing_date != '0000-00-00 00:00:00') JHtml::date($item->mailing_date, JText::_('BW_DATE_FORMAT_LC5')); ?>&nbsp;</td>
												<td align="center"><?php echo $item->author; ?></td>
												<td align="center"><?php echo $item->campaign; if ($item->campaign_archive_flag) echo " (".JText::_('ARCHIVED').")";?></td>
												<td align="center"><?php echo JHtml::date($item->archive_date, JText::_('BW_DATE_FORMAT_LC5')); ?></td>
											</tr>
										<?php endforeach;
										}
										else { ?>
											<tr class="row1">
												<td colspan="8"><strong><?php echo JText::_('COM_BWPOSTMAN_NO_DATA'); ?></strong></td>
											</tr><?php
										}
									?>
									</tbody>
								</table>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="layout" value="newsletters" /><!-- value can change if one clicks on another tab -->
			<input type="hidden" name="tab" value="newsletters" /><!-- value never changes -->
			<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
			<?php echo JHTML::_('form.token'); ?>
		</div>
	
		<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
	</form>
</div>