<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman newsletter controller for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import CONTROLLER object class
jimport('joomla.application.component.controllerform');

// Require helper class
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/helper.php');

/**
 * BwPostman Newsletter Controller
 *
 * @since		1.0.1
 * @package 	BwPostman-Admin
 * @subpackage 	Newsletters
 */
class BwPostmanControllerNewsletter extends JControllerForm
{
	/**
	 * @var    string  The prefix to use with controller messages.
	 * @since  1.0.4
	 */
	protected $text_prefix = 'COM_BWPOSTMAN_NL';

	/**
	 * Constructor.
	 *
	 * @param  array  $config  An optional associative array of configuration settings.
	 *
	 * @since  1.0.1
	 * @see    JController
	 */
	public function __construct($config = array())
	{
		parent::__construct($config);
		
		//register extra tasks
		$this->registerTask('setContent', 'setContent');
		$this->registerTask('sendmail', 'sendmail');
		$this->registerTask('sendtestmail', 'sendmail');
	}
	
	/**
	 * Method override to check if you can add a new record.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   1.0.1
	 */
	protected function allowAdd($data = array())
	{
		$user	= JFactory::getUser();
		
		return ($user->authorise('core.create', 'com_bwpostman'));
	}

	/**
	 * Method override to check if you can edit a record.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 *
	 * @since   1.0.1
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// Initialise variables.
		$recordId	= (int) isset($data[$key]) ? $data[$key] : 0;
		$user		= JFactory::getUser();
		$userId		= $user->get('id');

		// Check general edit permission first.
		if ($user->authorise('core.edit', 'com_bwpostman'))
		{
			return true;
		}

		// Check specific edit permission.
		if ($user->authorise('core.edit', 'com_bwpostman.newsletter.' . $recordId))
		{
			return true;
		}

		// Fallback on edit.own.
		// First test if the permission is available.
		if ($user->authorise('core.edit.own', 'com_bwpostman.newsletter.' . $recordId) || $user->authorise('core.edit.own', 'com_bwpostman'))
		{
			// Now test the owner is the user.
			$ownerId = (int) isset($data['created_by']) ? $data['created_by'] : 0;
			if (empty($ownerId) && $recordId)
			{
				// Need to do a lookup from the model.
				$record = $this->getModel()->getItem($recordId);

				if (empty($record))
				{
					return false;
				}

				$ownerId = $record->created_by;
			}

			// If the owner matches 'me' then do the test.
			if ($ownerId == $userId)
			{
				return true;
			}
		}
		return false;
	}


   /**
     * Method to check if you can send a newsletter.
     *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
     *
     * @return    boolean
     * @since    1.0.1
     */
    public static function allowSend($data = array(), $key = 'id')
    {
		// Initialise variables.
		$recordId	= (int) isset($data[$key]) ? $data[$key] : 0;
		$user		= JFactory::getUser();
    	
 		// Check general component send permission first.
		if ($user->authorise('core.send', 'com_bwpostman')) {
			return true;
		}

    	// Check specific send permission.
		if ($user->authorise('core.send', 'com_bwpostman.newsletter.' . $recordId))
		{
			return true;
		}
		return false;
	}
 
	/**
	 * Override method to edit an existing record, based on Joomla method.
	 * We need an override, because we want to handle state a bit different than Joomla at this point
	 *
	 * @param   string  $key     The name of the primary key of the URL variable.
	 * @param   string  $urlVar  The name of the URL variable if different from the primary key
	 * (sometimes required to avoid router collisions).
	 *
	 * @return  boolean  True if access level check and checkout passes, false otherwise.
	 *
	 * @since   1.0.1
	 */
	public function edit($key = null, $urlVar = null)
	{
		// Initialise variables.
		$app		= JFactory::getApplication();
		$jinput		= JFactory::getApplication()->input;
		$model		= $this->getModel();
		$table		= $model->getTable();
		$cid		= $jinput->post->get('cid', array(), 'array');
		$context	= "$this->option.edit.$this->context";

		// Determine the name of the primary key for the data.
		if (empty($key))
		{
			$key = $table->getKeyName();
		}

		// To avoid data collisions the urlVar may be different from the primary key.
		if (empty($urlVar))
		{
			$urlVar = $key;
		}
		
		// Get the previous record id (if any) and the current record id.
		$recordId = (int) (count($cid) ? $cid[0] : $jinput->getInt($urlVar));
		$checkin = property_exists($table, 'checked_out');

		// Access check.
		if (!$this->allowEdit(array($key => $recordId), $key))
		{
			$this->setError(JText::_('JLIB_APPLICATION_ERROR_EDIT_NOT_PERMITTED'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_list
					. $this->getRedirectToListAppend(), false
				)
			);

			return false;
		}

		// Attempt to check-out the new record for editing and redirect.
		if ($checkin && !$model->checkout($recordId))
		{
			// Check-out failed, display a notice but allow the user to see the record.
			$this->setError(JText::sprintf('JLIB_APPLICATION_ERROR_CHECKOUT_FAILED', $model->getError()));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return false;
		}
		else
		{
			// Check-out succeeded, push the new record id into the session.
			$this->holdEditId($context, $recordId);
//			$app->setUserState($context . '.data', null);

			$this->setRedirect(
				JRoute::_(
					'index.php?option=' . $this->option . '&view=' . $this->view_item
					. $this->getRedirectToItemAppend($recordId, $urlVar), false
				)
			);

			return true;
		}
	}

	/**
	 * Method to return to the BwPostman cover page if we clicked on the back button
	 * --> we have to modify the original backbutton because we have to delete the entry in the newsletters_tmp-table
	 *
	 * @access	public
	 * @return 	Redirect
	 */
	public function back()
	{
		$jinput	= JFactory::getApplication()->input;
				
		// Check for request forgeries
		if (!JSession::checkToken()) jexit(JText::_('JINVALID_TOKEN'));
		
		$link = JRoute::_('index.php?option=com_bwpostman', false);

		$this->setRedirect($link);
	}

	/**
	 * Method to set start tab 'basic' on cancel editing newsletter.
	 *
	 * @param	string	$key		The name of the key for the primary key.
	 *
	 * @access	public
	 * @return 	Redirect
	 * @since	1.0.8.2
	 */
	public function cancel($key = null)
	{
		$app	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;
		$Id		= $jinput->getInt('id', 0);

		// Check for request forgeries
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app->setUserState('com_bwpostman.newsletters.tab' . $Id, 'basic');

		$return = parent::cancel($key);

		$link = JRoute::_('index.php?option=com_bwpostman&view=newsletters', false);
		$this->setRedirect($link);
	}

	/**
	 * Method to set start tab 'basic' on save newsletter.
	 *
	 * @access	public
	 * @return	Redirect
	 * @since	1.0.8.2
	 */
	public function save($key = NULL, $urlVar = NULL)
	{
		$app	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;
		$Id		= $jinput->getInt('id', 0);

		// Check for request forgeries
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$app->setUserState('com_bwpostman.newsletters.tab' . $Id, 'basic');
		$return = parent::save();
	}

	/**
	 * Method to set the newsletter contents while changing tabs
	 *
	 * @access	public
	 * @since	1.0.1
	 */
	public function changeTab()
	{
		$app	= JFactory::getApplication();
		$jinput	= $app->input;
		$Id		= $jinput->getInt('id', 0);
		$tab	= $jinput->get('tab', 'basic');

		$app->setUserState('com_bwpostman.newsletters.tab' . $Id, $tab);
		
		$this->getModel('newsletter')->changeTab();

		$link = JRoute::_('index.php?option=com_bwpostman&task=newsletter.edit&id=' . $Id, false);

		$this->setRedirect($link);
	}

	/**
	 * Method to send out newsletter from newsletters list
	 *
	 * @access	public
	 */
	public function sendOut()
	{
		// get newsletter ID to send
		$app	= JFactory::getApplication();
		$jinput	= $app->input;
		$cids	= $jinput->get('cid', array(), 'array');
		$Id		= (int)$cids[0];
		$tab	= 'send';
		
		if (count($cids) > 1) $app->enqueueMessage(JText::_('COM_BWPOSTMAN_NL_WARNING_SENDING_ONLY_ONE_NL'), 'warning');

		// set edit tab to send
		$app->setUserState('com_bwpostman.newsletters.tab' . $Id, $tab);

		// redirect to edit, because we may want to sent regular or for testing
		$link = JRoute::_('index.php?option=com_bwpostman&task=newsletter.edit&id=' . $Id, false);

		$this->setRedirect($link);
	}
	
	/**
	 * Method to send a newsletter to the subscribers or the test-recipients
	 *
	 * @access	public
	 */
	public function sendmail()
	{
				
		// Check for request forgeries
		if (!JSession::checkToken()) jexit(JText::_('JINVALID_TOKEN'));
		
		$app	= JFactory::getApplication();
		$jinput	= $app->input;
		$model	= $this->getModel('newsletter');
		$user	= JFactory::getUser();
		$data	= $jinput->get('jform', array(), 'array');
		$error	= false;
		
		$task				= $jinput->get('task', 0);
		$unconfirmed		= $jinput->get('send_to_unconfirmed', 0);
		
		// Access check.
		if (!self::allowSend($data)) {
			$this->setError(JText::_('COM_BWPOSTMAN_NL_ERROR_SEND_NOT_PERMITTED'));
			$this->setMessage($this->getError(), 'error');

			$this->setRedirect(JRoute::_('index.php?option=com_bwpostman&view=newsletters', false));
			return false;
		}

		$cids			= $jinput->get('cid',  0, '', 'array');
		$tmp_id			= (int)$cids[0];
		$startsending	= 0;
		$link 			= JRoute::_('index.php?option=com_bwpostman&view=newsletters', false);
		$this->setRedirect($link);
		
		// Check the newsletter form
		$model->checkForm($data, $error);

		if ($error) {
			$app->enqueueMessage(JText::_('COM_BWPOSTMAN_NL_ERROR_SENDING_NL_CHECKFORM'), 'warning');
				
			$link = JRoute::_('index.php?option=com_bwpostman&view=newsletter&layout=edit&tpl=edit_basic&cid[]='.$tmp_id, false);
			$this->setRedirect($link);
		}
		else {
			// Store the newsletter into the newsletters-table
			if ($model->save($data)) { // save newsletter is ok
				if ($data['id'] == '0') {
					//get id of new inserted data
					$data['id']= $model->getState('newsletter.id');
				}
					
				switch ($task) {
					case "sendmail":
						// Check if there are assigned mailinglists or joomla user groups and if they contain subscribers/users
						if (!$model->checkRecipients($ret_msg, $data['id'], $unconfirmed)) {
							$app->enqueueMessage($ret_msg, 'error');
							$error	= true;
							$app->setUserState('com_bwpostman.newsletters.tab' . $data['id'], 'basic');
							$link = JRoute::_('index.php?option=com_bwpostman&task=newsletter.edit&id=' . $data['id'], false);
							$this->setRedirect($link);
						}
						else {
							$model->sendNewsletter('recipients', $data['id'], $unconfirmed);
							$startsending = 1;
							$model->checkin($data['id']);						
	
						}
						break;
					case "sendtestmail":
						// Check if there are test-recipients
						if (!$model->checkTestrecipients()) {
							$app->enqueueMessage(JText::_('COM_BWPOSTMAN_NL_ERROR_SENDING_NL_NO_TESTRECIPIENTS'), 'error');
							$error	= true;
							$app->setUserState('com_bwpostman.newsletters.tab' . $data['id'], 'basic');
							$link = JRoute::_('index.php?option=com_bwpostman&task=newsletter.edit&id=' . $data['id'], false);
							$this->setRedirect($link);
						}
						else {
							$model->sendNewsletter('testrecipients', $data['id'], $unconfirmed);
							$startsending = 1;
							$model->checkin($data['id']);
						}
						break;
				}
			
				if ($startsending){
					$app->setUserState('com_bwpostman.newsletters.mails_per_pageload', $jinput->get('mails_per_pageload'));
					$link = JRoute::_('index.php?option=com_bwpostman&view=newsletters&task=startsending&layout=queue', false);
					$this->setRedirect($link);
				}
			}
			else {
				$app->setUserState('com_bwpostman.newsletters.tab' . $data['id'], 'basic');
				$link = JRoute::_('index.php?option=com_bwpostman&task=newsletter.edit&id=' . $data['id'], false);
				$this->setRedirect($link);
			}
		}
	}

	/**
	 * Method to copy a newsletter 
	 *
	 * @access	public
	 */
	public function copy()
	{
		// Check for request forgeries
		if (!JSession::checkToken()) jexit(JText::_('JINVALID_TOKEN'));
		
		$app	= JFactory::getApplication();
		
		// Access check.
		if (!self::allowAdd()) {
			$app->enqueueMessage(JText::_('COM_BWPOSTMAN_NL_COPY_CREATE_RIGHTS_MISSING'), 'error');
			return false;
		}
				
		$jinput	= $app->input;
		$model	= $this->getModel('newsletter');
		
		// Get the newsletter IDs to copy
		$cid = $jinput->get('cid', array(), 'array');
		
		$model->copy($cid);
		
		parent::display();
	}

	/**
	 * Method to archive one or more newsletters
	 * --> subscribers-table: archive_flag = 1, set archive_date
	 *
	 * @access	public
	 * @return 	Redirect
	 */
	public function archive()
	{
		$jinput	= JFactory::getApplication()->input;
				
		// Check for request forgeries
		if (!JSession::checkToken()) jexit(JText::_('JINVALID_TOKEN'));
		
		// Which tab are we in?
		$layout = $jinput->get('tab', 'unsent');

		// Get the selected newsletter(s)
		$cid = $jinput->get('cid', array(0), 'post', 'array');
		JArrayHelper::toInteger($cid);

		$n		= count ($cid);
		$model	= $this->getModel('newsletter');
		
		if(!$model->archive($cid, 1)) { // Couldn't archive

			if ($n > 1) {
				echo "<script> alert ('".JText::_('COM_BWPOSTMAN_NLS_ERROR_ARCHIVING', true)."'); window.history.go(-1); </script>\n";
			}
			else {
				echo "<script> alert ('".JText::_('COM_BWPOSTMAN_NL_ERROR_ARCHIVING', true)."'); window.history.go(-1); </script>\n";
			}
		}
		else { // Archived successfully

			if ($n > 1) {
				$msg = JText::_('COM_BWPOSTMAN_NLS_ARCHIVED');
			}
			else {
				$msg = JText::_('COM_BWPOSTMAN_NL_ARCHIVED');
			}

			$link = JRoute::_('index.php?option=com_bwpostman&view=newsletters&layout='.$layout, false);
			$this->setRedirect($link, $msg);
		}
	}
}